#!/bin/bash

show_help(){
	echo "Usage: $(basename "$0") -i <input_csv> -o <output_dir>"
	echo
	echo "Download HBN files from AWS S3 paths listed in a CSV file"
	echo
	echo "Options:"
	echo "	-i <input_csv>	Path to the input CSV file containing AWS file paths."
	echo "	-o <output_dir>	Path to the directory where files will be downloaded."
	echo "	-h 		Display this help message and exit."
	echo
	echo "Example:"
	echo "	$(basename "$0") -i aws_links.csv -o ./downloads"
	echo
	exit 0
} 


while getopts o:i:h flag;
do
	case ${flag} in
		o) output=${OPTARG} ;;
		i) input=${OPTARG} ;;
		h) show_help ;;
		*) show_help ;;
	esac
done

if [[ -z ${input} || -z ${output} ]]; then
	echo "Error: both -i and -o options are required."
	echo
	show_help
fi

if [[ ! -d ${output} ]]; then
	echo "Creating output directory..."
	mkdir -p "${output}"
fi

while IFS=, read -r filepath;
do 
    filepath=$(echo "$filepath" | tr -d '\r')
	exactPath=${filepath#*/*/*/*/*/*/*/}

	if [ "${exactPath}" == "" ]; then
		echo "${filepath} ignored because it is a directory."
	else
		echo "Downloading ${filepath}"
		set -x
		mkdir -p "${output}/$(dirname ${exactPath})"
		aws s3 cp ${filepath} ${output}/${exactPath} --no-sign-request ##--no-verify-ssl
		set +x
	fi
done < ${input}